//Program 3:Display of 2D filters frequency responses and processing the images using these filters
//Reference: "Digital Image Processing",Dr.S.Jayaraman,S.Esakkirajan,T.Veerakumar,TMH,2011
//Note: The in-built scilab functions fft2d and ifft2d are not working properly
//It give wrong results.
//Use My functions for 2D-FFT and 2D-IFFT.
//Software version
//OS Windows7
//Scilab5.4.1
//Image Processing Design Toolbox 8.3.1-1
//Scilab Image and Video Proccessing toolbox 0.5.3.1-2
clc;
close;
clear;
exec('C:\Users\senthilkumar\Desktop\Chandra_Mohan_LAB\Digital_Image_ProcessingLab\fft2d.sce')
exec('C:\Users\senthilkumar\Desktop\Chandra_Mohan_LAB\Digital_Image_ProcessingLab\ifft2d.sce')
im1 = imread('C:\Users\senthilkumar\Desktop\Chandra_Mohan_LAB\Digital_Image_ProcessingLab\balloonsnoisy.png');//colour noise image
im = rgb2gray(im1);//gray noise image
fc = 100; //cut off frequency -more features choose high cutoff frequency
n = 1;//filter order =1
[co,ro]= size(im);
cx = round(co/2); //centre of the image
cy = round(ro/2);
IM = fft2d(double(im));
imf = fftshift(IM);
H = zeros(co,ro);
for i = 1:co
    for j = 1:ro
        d = (i-cx).^2+(j-cy).^2;
        H(i,j) = 1/(1+((d/fc/fc).^(2*n))); //Low Pass Butterworth First Order filter
    end
end
out_im = imf.*H;
out = abs(ifft2d(out_im));
out = uint8(out);
figure
ShowColorImage(im1,'Colour Noisy Image')
figure
ShowImage(im,'Gray Noise Image')
figure
ShowImage(H,'Low Pass Filter Frequency Response')
figure
ShowImage(out,'Filtered Image')
